<?php
/*
 * 🎵 @ Playlist Manager - Dashboard
 * 🚀 @ Version: 1.0.0
 * 🗕 @ Last Updated: 10/07/2025
 */

include "includes/header.php";
?>

<!-- Font Awesome preload + fallback -->
<link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" as="style" onload="this.onload=null;this.rel='stylesheet'">
<noscript><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"></noscript>

<style>
:root {
  --md3-primary: #4f46e5;
  --md3-secondary: #03dac6;
  --md3-bg: #1e1e2f;
  --md3-surface: #2c2c3e;
  --md3-on-surface: #ffffff;
  --md3-outline: #5c5c7c;
  --md3-shadow: rgba(0, 0, 0, 0.2);
}
body {
  background-color: var(--md3-bg);
  color: var(--md3-on-surface);
}
.card {
  border: none;
  border-radius: 16px;
  background-color: var(--md3-surface);
  box-shadow: 0 4px 20px var(--md3-shadow);
  transition: transform 0.3s ease, box-shadow 0.3s ease;
}
.card:hover {
  transform: translateY(-6px);
  box-shadow: 0 8px 24px rgba(0, 0, 0, 0.3);
}
.card-title {
  font-weight: 600;
}
.btn {
  border-radius: 28px;
  font-weight: 500;
  transition: all 0.3s ease;
}
.btn:hover {
  transform: scale(1.03);
  box-shadow: 0 4px 12px rgba(0,0,0,0.2);
}
.ripple {
  position: relative;
  overflow: hidden;
}
.ripple-effect {
  position: absolute;
  border-radius: 50%;
  transform: scale(0);
  background: rgba(255,255,255,0.4);
  animation: ripple-animation 600ms linear;
  pointer-events: none;
}
@keyframes ripple-animation {
  to {
    transform: scale(3);
    opacity: 0;
  }
}
@media (max-width: 576px) {
  .card-body i { font-size: 2rem !important; }
  .card-body h5 { font-size: 1rem; }
  .card-body p { font-size: 0.875rem; }
}
</style>

<div class="container-fluid mt-4">
  <div class="row">
    <div class="col-12 text-center mb-4">
      <h2><i class="fas fa-home" loading="lazy"></i> Tela Principal</h2>
    </div>
  </div>
  <div class="row justify-content-center">
    <?php
    $cards = [
      ["playlists.php", "users", "Gerenciar Playlists", "Adicione, edite ou remova usuários e suas playlists.", "Acessar Playlists", "primary"],
      ["dns.php", "server", "Servidores de DNS", "Gerencie os servidores DNS para suas playlists.", "Acessar DNS", "info"],
      ["ads.php", "ad", "Enviar Anúncios", "Configure e envie anúncios para seus usuários.", "Acessar Anúncios", "warning"],
      ["mRTXAdsSetting.php", "cog", "Autoads/Manual", "Gerencie as configurações de anúncios automáticos e manuais.", "Acessar Configurações", "secondary"],
      ["themes.php", "palette", "Selecionar Tema", "Personalize o tema da sua aplicação.", "Selecionar Tema", "dark"],
      ["settings.php", "comment-alt", "Mensagem Servidores", "Envie mensagens para os servidores.", "Configurar Mensagens", "success"],
      ["#", "paint-brush", "Personalizar App", "Acesse as opções de personalização do aplicativo.", "Personalizar App", "danger", true],
      ["qrcode.php", "qrcode", "Alterar QR Code", "Atualize o código QR do seu sistema.", "Alterar QR Code", "info"],
      ["chatbot.php", "robot", "Teste Automático", "Execute testes automáticos no seu sistema.", "Acessar Teste", "primary"],
      ["pagamento.php", "money-bill-wave", "Pagamento", "Gerencie as configurações de pagamento.", "Acessar Pagamento", "warning"],
      ["user.php", "user-cog", "Meu Perfil", "Acesse e gerencie suas informações de perfil.", "Acessar Perfil", "dark"]
    ];

    foreach ($cards as $card) {
      $modal = isset($card[6]) ? 'data-toggle="modal" data-target="#customizeModal"' : "";
      echo "<div class='col-md-4 col-sm-6 mb-4'>
        <div class='card text-center bg-{$card[5]} text-white'>
          <div class='card-body'>
            <i class='fas fa-{$card[1]} fa-3x mb-3' loading='lazy'></i>
            <h5 class='card-title'>{$card[2]}</h5>
            <p class='card-text'>{$card[3]}</p>
            <a href='{$card[0]}' class='btn btn-light btn-block' {$modal}>{$card[4]}</a>
          </div>
        </div>
      </div>";
    }
    ?>
  </div>
</div>

<!-- Ripple script com defer -->
<script defer>
document.addEventListener("DOMContentLoaded", () => {
  document.querySelectorAll('.btn').forEach(btn => {
    btn.classList.add('ripple');
    btn.addEventListener('click', function(e) {
      const circle = document.createElement("span");
      circle.classList.add("ripple-effect");
      const rect = this.getBoundingClientRect();
      const size = Math.max(rect.width, rect.height);
      circle.style.width = circle.style.height = size + 'px';
      circle.style.left = (e.clientX - rect.left - size / 2) + 'px';
      circle.style.top = (e.clientY - rect.top - size / 2) + 'px';
      this.appendChild(circle);
      setTimeout(() => circle.remove(), 600);
    });
  });
});
</script>

<?php include "includes/footer.php"; ?>
