<?php include 'includes/header.php'; 

if (file_exists('mensagem.txt')) {
    $data = json_decode(file_get_contents('mensagem.txt'), true);
    $mensagem = htmlspecialchars($data['mensagem']);
    $cor = htmlspecialchars($data['cor']);
    $bgcolor = htmlspecialchars($data['bgcolor']);
    $opacity = htmlspecialchars($data['opacity']);
    $fontSize = isset($data['fontSize']) ? htmlspecialchars($data['fontSize']) : "16";
    $efeito = isset($data['efeito']) ? htmlspecialchars($data['efeito']) : "scroll";
} else {
    $mensagem = "Nenhuma mensagem gravada.";
    $cor = "#000000";
    $bgcolor = "#ffffff";
    $opacity = "1";
    $fontSize = "16";
    $efeito = "scroll";
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Enviar Mensagem</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@simonwep/pickr/dist/themes/classic.min.css" />
    <script src="https://cdn.jsdelivr.net/npm/@simonwep/pickr"></script>
    <style>
        .color-picker {
            margin-top: 10px;
        }

        .container-md3 {
            max-width: 650px;
            margin: auto;
        }

        .card-md3 {
            background-color: #ffffff;
            border-radius: 16px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.08);
            padding: 2rem;
            animation: fadeIn 0.3s ease-in-out;
        }

        .card-md3 h2 {
            text-align: center;
            color: #202124;
            font-weight: 500;
            margin-bottom: 1.5rem;
        }

        label {
            font-weight: 500;
            margin-top: 1rem;
            display: block;
            color: #444;
        }

        input[type="text"],
        input[type="number"],
        select {
            width: 100%;
            padding: 0.75rem 1rem;
            border: 1px solid #ccc;
            border-radius: 12px;
            font-size: 1rem;
            margin-top: 0.4rem;
            transition: border-color 0.2s;
        }

        input[type="range"] {
            width: 100%;
            margin-top: 0.5rem;
        }

        input:focus,
        select:focus {
            border-color: #6200ea;
            outline: none;
        }

        .pickr {
            margin-top: 0.5rem;
        }

        .form-footer {
            margin-top: 1.5rem;
        }

        .form-footer button {
            width: 100%;
            padding: 0.9rem;
            font-size: 1rem;
            font-weight: 500;
            background-color: #6200ea;
            border: none;
            border-radius: 28px;
            color: white;
            transition: background-color 0.3s ease;
        }

        .form-footer button:hover {
            background-color: #4500b5;
        }

        iframe {
            width: 100%;
            height: 40px;
            border: none;
            border-radius: 12px;
            margin-top: 1.5rem;
            background-color: #fafafa;
        }

        #opacityValue, #fontSizeValue {
            margin-left: 10px;
            font-weight: bold;
            color: #333;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(8px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
    <script>
        function updatePreview() {
            const mensagem = document.getElementById('mensagem').value;
            const cor = document.getElementById('cor').value;
            const bgColor = document.getElementById('bgcolor').value;
            const opacity = document.getElementById('opacity').value;
            const fontSize = document.getElementById('fontSize').value;
            const efeito = document.getElementById('efeito').value;
            const iframe = document.getElementById('preview');

            const url = `api/msg.php?mensagem=${encodeURIComponent(mensagem)}&cor=${encodeURIComponent(cor)}&bgColor=${encodeURIComponent(bgColor)}&opacity=${encodeURIComponent(opacity)}&fontSize=${encodeURIComponent(fontSize)}&efeito=${encodeURIComponent(efeito)}`;
            iframe.src = url;

            document.getElementById('opacityValue').textContent = opacity;
            document.getElementById('fontSizeValue').textContent = fontSize + 'px';
        }

        document.addEventListener('DOMContentLoaded', function () {
            const pickrTextColor = Pickr.create({
                el: '#cor-picker',
                theme: 'classic',
                default: '<?php echo $cor; ?>',
                components: {
                    preview: true,
                    opacity: true,
                    hue: true,
                    interaction: {
                        hex: true,
                        rgba: true,
                        input: true,
                        save: true
                    }
                }
            });

            pickrTextColor.on('save', (color) => {
                document.getElementById('cor').value = color.toHEXA().toString();
                updatePreview();
            });

            const pickrBgColor = Pickr.create({
                el: '#bgcolor-picker',
                theme: 'classic',
                default: '<?php echo $bgcolor; ?>',
                components: {
                    preview: true,
                    opacity: true,
                    hue: true,
                    interaction: {
                        hex: true,
                        rgba: true,
                        input: true,
                        save: true
                    }
                }
            });

            pickrBgColor.on('save', (color) => {
                document.getElementById('bgcolor').value = color.toHEXA().toString();
                updatePreview();
            });

            document.getElementById('opacity').addEventListener('input', updatePreview);
            document.getElementById('fontSize').addEventListener('input', updatePreview);
        });
    </script>
</head>
<body>
    <div class="container-md3">
        <div class="card-md3">
            <h2>Enviar Mensagem de Texto</h2>
            <form action="salvar_mensagem.php" method="post">
                <label for="mensagem">Mensagem:</label>
                <input type="text" id="mensagem" name="mensagem" value="<?php echo $mensagem; ?>" required>

                <label for="cor">Cor do Texto:</label>
                <input type="text" id="cor" name="cor" value="<?php echo $cor; ?>" required>
                <div id="cor-picker" class="pickr"></div>

                <label for="bgcolor">Cor de Fundo:</label>
                <input type="text" id="bgcolor" name="bgcolor" value="<?php echo $bgcolor; ?>" required>
                <div id="bgcolor-picker" class="pickr"></div>

                <label for="opacity">Opacidade: <span id="opacityValue"><?php echo $opacity; ?></span></label>
                <input type="range" id="opacity" name="opacity" min="0" max="1" step="0.1" value="<?php echo $opacity; ?>">

                <label for="fontSize">Tamanho do Texto: <span id="fontSizeValue"><?php echo $fontSize; ?>px</span></label>
                <input type="number" id="fontSize" name="fontSize" min="8" max="72" value="<?php echo $fontSize; ?>" required>

                <label for="efeito">Efeito:</label>
                <select id="efeito" name="efeito" required>
                    <option value="scroll" <?php echo ($efeito === 'scroll' ? 'selected' : ''); ?>>Rolante</option>
                    <option value="static" <?php echo ($efeito === 'static' ? 'selected' : ''); ?>>Parado</option>
                    <option value="blink" <?php echo ($efeito === 'blink' ? 'selected' : ''); ?>>Piscando</option>
                    <option value="typing" <?php echo ($efeito === 'typing' ? 'selected' : ''); ?>>Digitando</option>
                </select>

               <div class="container-md3">
    <div class="card-md3">
        <h2>Mandar Para Texto Acima</h2>
        <form action="salvar_mensagem.php" method="post">
            <!-- Campos do formulário -->
            <label for="mensagem">Mensagem:</label>
            <input type="text" id="mensagem" name="mensagem" value="<?php echo $mensagem; ?>" required>
            <div class="form-footer">
                <button type="submit">Enviar</button>
            </div>
        </form>
    </div>
</div>

    <?php include 'includes/footer.php'; ?>
</body>
</html>
