<?php
/*
 * @ https://hospedagem.matrixch.store
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 17/06/2024
 */

// Desativa a exibição de erros PHP para uma experiência de usuário mais limpa em produção
ini_set("display_errors", 0);

// Inclui o cabeçalho para um layout de página consistente
include "includes/header.php";
?>

<style>
    .custom-button {
        padding: 10px 20px;
        border-radius: 5px; /* Cantos levemente arredondados para botões */
        transition: background-color 0.3s ease; /* Transição suave ao passar o mouse */
    }

    .custom-button:hover {
        opacity: 0.9; /* Efeito de hover sutil */
    }

    #url-form {
        display: none; /* Oculto por padrão, pode ser ativado por JS se necessário */
    }

    .custom-input {
        color: #007bff; /* Um azul agradável para o texto de entrada */
        border: 1px solid #ced4da; /* Borda clara para campos de entrada */
        border-radius: 4px; /* Campos de entrada arredondados */
        padding: 8px 12px;
    }

    .card {
        border-radius: 10px; /* Cartões mais arredondados */
        box-shadow: 0 4px 8px rgba(0,0,0,0.1); /* Sombra sutil para profundidade */
        margin-bottom: 20px; /* Espaço entre os cartões */
    }

    .card-header {
        background-color: #f8f9fa; /* Fundo claro para cabeçalhos de cartão */
        border-bottom: 1px solid #e9ecef; /* Linha separadora */
        padding: 15px 20px;
    }

    .card-title {
        color: #343a40; /* Texto mais escuro para títulos */
        font-weight: 600; /* Títulos mais fortes */
    }

    .ctinput label {
        font-weight: 500; /* Rótulos ligeiramente mais fortes */
        margin-bottom: 5px;
        display: block; /* Torna os rótulos de nível de bloco para melhor espaçamento */
    }

    .ctbtn {
        background-color: #007bff; /* Azul primário para botões principais */
        color: white;
        border: none;
        padding: 10px 20px;
        border-radius: 5px;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    .ctbtn:hover {
        background-color: #0056b3; /* Azul mais escuro ao passar o mouse */
    }

    .alert-success {
        color: #155724;
        background-color: #d4edda;
        border-color: #c3e6cb;
        padding: 10px;
        margin-bottom: 15px;
        border-radius: 5px;
    }

    .alert-danger {
        color: #721c24;
        background-color: #f8d7da;
        border-color: #f5c6cb;
        padding: 10px;
        margin-bottom: 15px;
        border-radius: 5px;
    }

    /* Estilos para os cartões de seleção */
    .ad-option-card {
        cursor: pointer;
        border: 2px solid #e9ecef;
        transition: all 0.3s ease;
        padding: 20px;
        text-align: center;
        background-color: #fff;
    }

    .ad-option-card:hover {
        border-color: #007bff;
        box-shadow: 0 6px 12px rgba(0,0,0,0.15);
        transform: translateY(-3px);
    }

    .ad-option-card.selected {
        border-color: #28a745; /* Borda verde quando selecionado */
        box-shadow: 0 6px 12px rgba(40,167,69,0.2);
    }

    .ad-option-card .icon {
        font-size: 3rem;
        margin-bottom: 15px;
        color: #6c757d;
    }

    .ad-option-card.selected .icon {
        color: #28a745; /* Ícone verde quando selecionado */
    }

    .ad-option-card h4 {
        margin-bottom: 10px;
        color: #343a40;
    }

    .ad-option-card p {
        font-size: 0.9rem;
        color: #6c757d;
    }
</style>

<div class="col-md-8 mx-auto"> <div class="modal fade" id="how2" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Como Usar Este Recurso 🤔</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Bem-vindo(a) às **Configurações de Anúncios**! Aqui, você pode escolher facilmente como os anúncios são exibidos em seu site. Oferecemos duas opções principais:</p>
                    <ul>
                        <li>**Anúncios Automáticos (Recomendado) 🤖:** Deixe nosso sistema inteligentemente posicionar os anúncios em seu site para um desempenho ideal. Isso é ideal para a maioria dos usuários, exigindo configuração mínima.</li>
                        <li>**Anúncios Manuais ✍️:** Tenha controle total inserindo banners de anúncios exatamente onde você deseja. Perfeito se você tiver necessidades de design específicas.</li>
                    </ul>
                    <p>Basta clicar no cartão para o seu tipo de anúncio preferido e, em seguida, clicar no botão **"Salvar Configuração ✨"** para aplicar suas alterações. É simples assim! ✨</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <a href="https://www.tvsportguide.com/page/widget/" target="_blank" rel="noopener noreferrer">
                        <button type="button" class="btn btn-primary">Ir para a Página 🌐</button>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="card-body">
        <div class="card ctcard">
            <div class="card-header text-center">
                <h2 class="card-title"><i class="fa fa-cogs"></i>Ajustes de Anúncios</h2>
            </div>
            <div class="card-body">
                <?php
                // Inicializa a conexão com o banco de dados SQLite
                $db = new SQLite3("./api/studiolivecode.db");

                // Verifica erros de conexão com o banco de dados
                if (!$db) {
                    echo '<div class="alert alert-danger" role="alert">❌ Erro de conexão com o banco de dados. Por favor, tente novamente mais tarde.</div>';
                    exit();
                }

                // Cria a tabela 'adsstatus' se ela não existir
                $query = "CREATE TABLE IF NOT EXISTS adsstatus (id INTEGER PRIMARY KEY, adstype TEXT)";
                if (!$db->exec($query)) {
                    echo '<div class="alert alert-danger" role="alert">❌ Erro ao criar a tabela: ' . $db->lastErrorMsg() . '</div>';
                }

                // Obtém o tipo de anúncio atual do banco de dados
                $currentAdsType = '';
                $query = "SELECT adstype FROM adsstatus WHERE id = 1";
                $result = $db->querySingle($query);
                if ($result) {
                    $currentAdsType = $result;
                }

                // Lida com a requisição POST para atualizar as configurações de anúncios
                if ($_SERVER["REQUEST_METHOD"] == "POST") {
                    $ad_item = $_POST["ad_item"] ?? ''; // Usa o operador de coalescência nula por segurança

                    // Valida se um item de anúncio foi selecionado
                    if (empty($ad_item)) {
                        echo '<div class="alert alert-danger" role="alert">⚠️ Por favor, selecione um tipo de anúncio.</div>';
                    } else {
                        // Determina se deve INSERIR ou ATUALIZAR o registro
                        $updateQuery = '';
                        if ($db->querySingle("SELECT COUNT(*) FROM adsstatus") === 0) {
                            $updateQuery = "INSERT INTO adsstatus (adstype) VALUES (:ad_item)";
                        } else {
                            $updateQuery = "UPDATE adsstatus SET adstype = :ad_item WHERE id = 1";
                        }

                        // Prepara e executa a instrução SQL
                        $stmt = $db->prepare($updateQuery);
                        $stmt->bindValue(":ad_item", $ad_item, SQLITE3_TEXT);

                        if ($stmt->execute()) {
                            echo '<div class="alert alert-success" role="alert">✅ Tipo de anúncio definido com sucesso para <strong>"' . htmlspecialchars($ad_item) . '"</strong>!</div>';

                            // Copia o arquivo 'allads.php' apropriado com base na seleção
                            $source_folder = '';
                            if ($ad_item === "Manualads") {
                                $source_folder = "./Manualads/";
                            } elseif ($ad_item === "Autoads") {
                                $source_folder = "./Autoads/";
                            }

                            if (!empty($source_folder)) {
                                $source = $source_folder . "allads.php";
                                $destination = "./api/allads.php";

                                if (file_exists($source)) {
                                    if (copy($source, $destination)) {
                                        echo '<div class="alert alert-info" role="alert">🔄 Arquivo de configuração de anúncios sincronizado.</div>';
                                    } else {
                                        echo '<div class="alert alert-danger" role="alert">❌ Falha ao copiar o arquivo de configuração de anúncios.</div>';
                                    }
                                } else {
                                    echo '<div class="alert alert-danger" role="alert">❌ Erro: Arquivo "allads.php" não encontrado na pasta "' . htmlspecialchars($source_folder) . '".</div>';
                                }
                            }
                            // Atualiza currentAdsType após a atualização bem-sucedida
                            $currentAdsType = $ad_item;
                        } else {
                            echo '<div class="alert alert-danger" role="alert">❌ Erro ao atualizar o registro: ' . $db->lastErrorMsg() . '</div>';
                        }
                    }
                }
                ?>

                <form method="POST" action="" id="adSettingsForm">
                    <input type="hidden" name="ad_item" id="selectedAdItem" value="<?php echo htmlspecialchars($currentAdsType); ?>">

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card ad-option-card <?php echo ($currentAdsType === 'Autoads') ? 'selected' : ''; ?>" data-value="Autoads">
                                <div class="card-body">
                                    <div class="icon">🤖</div>
                                    <h4>Anúncios Automáticos (Recomendado)</h4>
                                    <p>Nosso sistema inteligentemente posiciona anúncios para você. Perfeito para **filmes automáticos** e otimização de receita sem esforço manual.</p>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card ad-option-card <?php echo ($currentAdsType === 'Manualads') ? 'selected' : ''; ?>" data-value="Manualads">
                                <div class="card-body">
                                    <div class="icon">✍️</div>
                                    <h4>Anúncios Manuais</h4>
                                    <p>Você tem controle total para inserir **banners manuais** específicos onde desejar. Ideal para posicionamentos personalizados e campanhas de anúncios diretas.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-center mt-4">
                        <button type="submit" name="submit" class="btn btn-primary ctbtn mr-2">
                            Salvar Configuração ✨
                        </button>
                        <button type="button" class="btn btn-info custom-button" data-toggle="modal" data-target="#how2">
                            Como Usar? ℹ️
                        </button>
                    </div>
                </form>

                <?php
                // Fecha a conexão com o banco de dados
                $db->close();
                ?>
            </div>
        </div>
    </div>
</div>

<?php
// Inclui o rodapé para um layout de página consistente
include "includes/footer.php";
?>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const adOptionCards = document.querySelectorAll('.ad-option-card');
        const selectedAdItemInput = document.getElementById('selectedAdItem');

        // Função para atualizar a seleção do cartão
        function updateSelection(selectedValue) {
            adOptionCards.forEach(card => {
                card.classList.remove('selected');
                if (card.dataset.value === selectedValue) {
                    card.classList.add('selected');
                }
            });
            selectedAdItemInput.value = selectedValue;
        }

        // Define a seleção inicial com base no valor do input oculto
        updateSelection(selectedAdItemInput.value);

        // Adiciona ouvintes de evento de clique aos cartões
        adOptionCards.forEach(card => {
            card.addEventListener('click', function() {
                const value = this.dataset.value;
                updateSelection(value);
            });
        });
    });
</script>