<?php
ini_set("display_errors", 1);
error_reporting(32767);
include "includes/header.php";

$dbPath = "./api/studiolivecode.db";
$db = new SQLiteWrapper($dbPath);

// Atualiza tema se enviado
if (isset($_POST["theme_id"])) {
    $db->update("themes", ["theme_id" => $_POST["theme_id"]], "id = :id", [":id" => 1]);
    echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=1'</script>";
    exit;
}

// Obtém o tema atual com verificação segura
$currentThemeRow = $db->select("themes", "theme_id", "id = 1");
$currentThemeId = $currentThemeRow[0]["theme_id"] ?? 0;
?>

<!-- Font Awesome com defer para evitar bloqueio -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" media="all" onload="this.onload=null;this.rel='stylesheet'">
<noscript>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</noscript>

<div class="container my-5">
  <div class="card shadow-lg border-0">
    <div class="card-header bg-primary text-white text-center">
      <h2>🎨 Configuração de Tema</h2>
    </div>
    <div class="card-body p-4 text-center">
      <p class="lead mb-4">✨ Clique na imagem abaixo para confirmar automaticamente o tema desejado!</p>
      <div class="theme-thumbnails">
        <?php foreach ([4, 5, 3] as $num): 
          $selectedClass = ($currentThemeId == $num) ? "selected-theme" : ""; ?>
          <form method="post" class="theme-item <?= $selectedClass ?> d-inline-block m-2" style="border: none;">
            <input type="hidden" name="theme_id" value="<?= $num ?>">
            <button type="submit" class="theme-button">
              <img src="img/theme_<?= $num ?>.png" alt="Theme <?= $num ?>" class="img-thumbnail rounded shadow-sm theme-img" loading="lazy">
            </button>
          </form>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
</div>

<style>
.theme-thumbnails {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
  gap: 20px;
  margin-top: 20px;
}
.theme-item {
  text-align: center;
  border-radius: 15px;
}
.theme-button {
  background: none;
  border: none;
  padding: 0;
  cursor: pointer;
  border-radius: 15px;
  transition: transform 0.2s ease, filter 0.2s ease;
}
.theme-button:active {
  transform: scale(0.97);
  filter: brightness(1.1);
}
.theme-img {
  width: 100%;
  border-radius: 15px;
  transition: box-shadow 0.3s, filter 0.3s;
}
.selected-theme .theme-img {
  animation: neonGlow 1.5s infinite alternate;
  filter: brightness(1.2);
}
@keyframes neonGlow {
  0% { box-shadow: 0 0 10px #00faff, 0 0 20px #00faff, 0 0 30px #00faff; }
  100% { box-shadow: 0 0 20px #00faff, 0 0 30px #00faff, 0 0 40px #00faff; }
}
</style>

<?php include "includes/footer.php"; ?>
