<!DOCTYPE html>
<html lang="pt-BR">
<?php
// Função para registrar logs em um arquivo
function logMessage($message) {
    $logFile = "log.txt";
    $timestamp = date("Y-m-d H:i:s");
    file_put_contents($logFile, "[$timestamp] $message" . PHP_EOL, FILE_APPEND);
}

// Função para remover todos os arquivos da pasta
function clearDirectory($dir) {
    $files = glob($dir . '*');
    foreach ($files as $file) {
        if (is_file($file)) {
            unlink($file); // Deleta o arquivo
        }
    }
}

// Processamento do backend
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    logMessage("Requisição POST recebida.");

    // Verificar e criar o diretório de upload
    $targetDir = "splashscreen/";
    if (!is_dir($targetDir)) {
        if (mkdir($targetDir, 0777, true)) {
            logMessage("Diretório '$targetDir' criado com sucesso.");
        } else {
            logMessage("Erro ao criar o diretório '$targetDir'.");
            http_response_code(500);
            echo "Erro ao criar o diretório.";
            exit;
        }
    }

    // Limpar a pasta de upload
    clearDirectory($targetDir);

    // Nome do arquivo para armazenar o registro
    $urlFile = $targetDir . "splashscreen.txt";

    // Limpar o arquivo splashscreen.txt antes de escrever
    if (file_put_contents($urlFile, '') === false) {
        logMessage("Erro ao limpar o arquivo '$urlFile'.");
        http_response_code(500);
        echo "Erro ao limpar o arquivo splashscreen.txt.";
        exit;
    } else {
        logMessage("Arquivo '$urlFile' limpo com sucesso.");
    }

    // Processar upload do arquivo de vídeo
    if (isset($_FILES['video'])) {
    logMessage("Arquivo de vídeo detectado no POST.");

    // Gera um nome único para o arquivo, mantendo a extensão original
    $fileExtension = pathinfo($_FILES['video']['name'], PATHINFO_EXTENSION);
    $newFileName = uniqid('video_', true) . '.' . $fileExtension; // Exemplo: video_64b5f7eaed9b9.12345.mp4
    $targetFilePath = $targetDir . $newFileName;

    // Move o arquivo para o destino com o novo nome
    if (move_uploaded_file($_FILES['video']['tmp_name'], $targetFilePath)) {
        logMessage("Arquivo salvo com o nome: $newFileName em: $targetFilePath");
        $targetFilePath = "https://1.painelmaster.lol/splashscreen/" . $newFileName;

            // Salvar o caminho no arquivo splashscreen.txt
            if (file_put_contents($urlFile, $targetFilePath . PHP_EOL, FILE_APPEND)) {
                logMessage("Caminho salvo em '$urlFile': $targetFilePath");
                echo "Arquivo salvo com sucesso em: " . $targetFilePath;
            } else {
                logMessage("Erro ao salvar o caminho no arquivo splashscreen.txt.");
                http_response_code(500);
                echo "Erro ao salvar o caminho no splashscreen.txt.";
            }
        } else {
            logMessage("Erro ao salvar o arquivo de vídeo.");
            http_response_code(500);
            echo "Erro ao salvar o arquivo.";
        }
        exit;
    }

    // Processar URL enviada
    elseif (isset($_POST['url'])) {
        logMessage("URL detectada no POST.");

        $videoUrl = $_POST['url'];
        if (file_put_contents($urlFile, $videoUrl . PHP_EOL, FILE_APPEND)) {
            logMessage("URL salva em '$urlFile': $videoUrl");
            echo "URL salva com sucesso: " . $videoUrl;
        } else {
            logMessage("Erro ao salvar a URL no arquivo splashscreen.txt.");
            http_response_code(500);
            echo "Erro ao salvar a URL no splashscreen.txt.";
        }
        exit;
    }

    // Nenhum dado válido enviado
    else {
        logMessage("Nenhum dado válido enviado no POST.");
        http_response_code(400);
        echo "Nenhum dado enviado.";
        exit;
    }
} else {

}
?>




<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0"> <!-- Meta tag para responsividade -->
  <link rel="shortcut icon" type="image/x-icon" href="https://cpwebassets.codepen.io/assets/favicon/favicon-aec34940fbc1a6e787974dcd360f2c6b63348d4b1f4e06c77743096d55480f33.ico" />
  <link rel="mask-icon" type="image/x-icon" href="https://cpwebassets.codepen.io/assets/favicon/logo-pin-b4b4269c16397ad2f0f7a01bcdf513a1994f4c94b8af2f191c09eb0d601762b1.svg" color="#111" />
  <title>Configurar Tela de Upload</title>
  <style>
    * {
      --bs-body-bg: #1e1e2c;
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: "Verdana", "Helvetica", sans-serif;
      background-color: #1e1e2c;
      color: #e8e8ec;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }

    .upload-container {
      text-align: center;
      background-color: #2b2b3b;
      border-radius: 10px;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.3);
      overflow: hidden;
      width: 90%; /* Ajuste a largura para ser 90% da tela */
      max-width: 500px; /* Defina uma largura máxima */
    }

    h1 {
      margin: 20px 0;
      font-size: 1.5rem;
      color: #fff;
    }

    .upload-zone {
      background-color: #39394a;
      border: 2px dashed #5c5c7a;
      color: #c4c4d8;
      padding: 20px;
      cursor: pointer;
    }

    .upload-zone p {
      margin: 0;
    }

    .upload-zone span {
      font-style: italic;
      font-size: 0.9rem;
      color: #a1a1b3;
    }

    .separator {
      margin: 10px 0;
      color: #a1a1b3;
      font-size: 0.9rem;
    }

    .paste-url {
      padding: 10px;
      background-color: #2b2b3b;
      border: 1px solid #5c5c7a;
      border-radius: 5px;
      color: #e8e8ec;
      width: 90%;
      font-size: 0.9rem;
      outline: none;
      margin: 10px auto 20px auto;
      display: block;
      text-align: center;
    }

    .upload-zone video {
      max-width: 100%;
      max-height: 100%;
    }

    .upload-zone.dragover {
      background-color: #421765;
      border-color: #00acc1;
    }

    .input-wrap {
      position: relative;
    }

    .load {
      display: none;
      position: absolute;
      top: 50%;
      right: 30px;
      transform: translateY(-50%);
      background-color: #2b2b3b;
      color: black;
      border: none;
      padding: 5px 10px;
      border-radius: 3px;
      cursor: default;
    }

    .loader-item {
      display: inline-block;
      width: 0.7em;
      height: 0.7em;
      color: inherit;
      vertical-align: middle;
      pointer-events: none;
      font-size: 40px;
      border: 5px solid #4361BA;
      border-bottom-color: transparent;
      border-radius: 50%;
      animation: 1s loader-animation linear infinite;
      position: relative;
    }
    
    .confirm-button {
      display: none;
      margin: 20px auto;
      padding: 10px 20px;
      background-color: #00acc1;
      color: #fff;
      border: none;
      border-radius: 5px;
      cursor: pointer;
    }

    .confirm-button:hover {
      background-color: #008ea1;
    }

    @keyframes loader-animation {
      0% {
        transform: rotate(0deg);
      }

      100% {
        transform: rotate(360deg);
      }
    }

    /* Media Queries para dispositivos menores */
    @media (max-width: 600px) {
      .upload-container {
        width: 95%; /* Aumenta a largura da container em telas menores */
      }
      h1 {
        font-size: 1.2rem;
      }
      .paste-url {
        width: 100%; /* Faz o campo de URL preencher a tela inteira */
      }
      .upload-zone {
        padding: 15px;
      }
      .confirm-button {
        width: 100%;
      }
    }

  </style>
</head>


<body>
  <div class="upload-container">
    <div id="upload" class="upload-zone">
      <p>Escolha um vídeo e faça upload aqui...</p>
      <span>Tamanho máximo: 20MB</span>
    </div>
    <div class="separator">&mdash; ou &mdash;</div>
    <div class="input-wrap">
      <input id="url" type="text" class="paste-url" placeholder="Cole o link do vídeo aqui...">
       <button id="confirmButton" class="confirm-button">Confirmar Envio</button>
      <div class="load">
        <div class="loader-item loader-1"></div>
      </div>
    </div>
  </div>
  <script>
    const videoArea = document.getElementById('upload');
    const fileInput = document.createElement('input');
    fileInput.type = 'file';
    fileInput.accept = 'video/*';
    fileInput.style.display = 'none';
     const confirmButton = document.getElementById('confirmButton');

    document.body.appendChild(fileInput);
    
    let videoSource = null; // Armazena a fonte do vídeo (arquivo ou URL)
    let isFile = false; // Flag para diferenciar arquivo ou URL

    function showConfirmButton() {
      confirmButton.style.display = 'block';
    }

    videoArea.addEventListener('click', () => {
      fileInput.click();
    });

    fileInput.addEventListener('change', event => {
      const file = event.target.files[0];
      if (file && file.type.startsWith('video/')) {
        displayVideo(file);
        isFile = true;
        videoSource = file;
        showConfirmButton();
      } else {
        console.log("O arquivo selecionado não é um vídeo");
      }
    });

    document.addEventListener('paste', event => {
      const clipboardItems = event.clipboardData.items;
      let foundVideo = false;

      for (let item of clipboardItems) {
        if (item.type.startsWith('video/')) {
          const file = item.getAsFile();
          displayVideo(file);
          isFile = true;
          videoSource = file;
          showConfirmButton();
          foundVideo = true;
          break;
        }
      }

      if (!foundVideo) {
        console.log("Nenhum vídeo encontrado na ação de colar");
      }
    });

    videoArea.addEventListener('dragover', event => {
      event.preventDefault();
      videoArea.classList.add('dragover');
    });

    videoArea.addEventListener('dragleave', () => {
      videoArea.classList.remove('dragover');
    });

    videoArea.addEventListener('drop', event => {
      event.preventDefault();
      videoArea.classList.remove('dragover');

      const file = event.dataTransfer.files[0];
      if (file && file.type.startsWith('video/')) {
        displayVideo(file);
        showConfirmButton();
        videoSource = file;
        isFile = true;
      } else {
        console.log("O arquivo arrastado não é um vídeo");
      }
    });

    const urlInput = document.getElementById('url');
    const loadingIndicator = document.querySelector('.load');
    let typingTimer;
    const delay = 2000;

    function checkUrlStatus() {
      const url = urlInput.value;
      const video = document.createElement('video');
      video.src = url;

      loadingIndicator.style.display = 'none';

      video.onloadeddata = function () {
        urlInput.style.borderColor = 'green';
        isFile = false;
        videoSource = url;
        displayVideo(url);
        showConfirmButton();
      };
      video.onerror = function () {
        urlInput.style.borderColor = 'red';
      };
    }

    urlInput.addEventListener('input', () => {
      clearTimeout(typingTimer);
      loadingIndicator.style.display = 'block';

      const existingVideo = videoArea.querySelector('video');
      if (existingVideo) {
        videoArea.removeChild(existingVideo);
        videoArea.innerHTML = "<p>Escolha um vídeo ou arraste para cá</p><span>Tamanho máximo: 20 MB.</span>";
      }

      typingTimer = setTimeout(checkUrlStatus, delay);
    });

    function displayVideo(source) {
      const video = document.createElement('video');
      video.controls = true;

      if (source instanceof File) {
        video.src = URL.createObjectURL(source);
      } else if (typeof source === 'string') {
        video.src = source;
      }

      videoArea.textContent = '';
      videoArea.appendChild(video);
    }
    
    confirmButton.addEventListener('click', () => {
      const formData = new FormData();
      console.log(isFile);
      console.log(videoSource);
      if (isFile && videoSource instanceof File) {
        formData.append('video', videoSource);
      } else if (!isFile && typeof videoSource === 'string') {
        formData.append('url', videoSource);
      }
      
      console.log(formData);

      fetch('', {
        method: 'POST',
        body: formData,
      })
        .then(response => response.text())
        .then(data => {
          alert('Enviado com sucesso!');
          console.log(data);
        })
        .catch(error => {
          alert('Erro ao enviar!');
          console.error(error);
        });
    });
  </script>
</body>

</html>
