<?php

ini_set('display_errors', 0);
if(session_status() === PHP_SESSION_NONE) session_start();
include(__DIR__ . '/functions.php');
$adTypeJsonPath = __DIR__ . '/ad_type.json';
$adb = new SQLite3('./api/.adb.db');
$adb3 = new SQLite3('./api/.db_logo.db');
$adb4 = new SQLite3('./api/.db_bg.db');
$adb = new SQLite3('./api/studiolivecode.db'); // Duplicado, verificar se é intencional
$adTypeData = json_decode(file_get_contents($adTypeJsonPath), true);
$currentAdType = $adTypeData['adType'] ?? 'manual';

if ($currentAdType === 'tmdb') {
    $adsPageUrl = "tmdb_api.php";
} else {
    $adsPageUrl = "ads.php";
}

if (!isset($_SESSION['name'])) {
    header("Location: index.php");
    exit;
}

$log_check = $db->select('users', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;

if ($_SESSION['name'] !== $loggedinuser) {
    header("Location: index.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>IBO XFAST</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="author" content="IBO XFAST">

    <!-- CSS: Apenas uma versão do Bootstrap e bibliotecas -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/themes/darkly/bootstrap.css" title="main">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link href="css/simple-sidebar.css" rel="stylesheet">
<style>
:root {
  --md3-primary: #4f46e5;
  --md3-secondary: #03dac6;
  --md3-background: #1e1e2f;
  --md3-surface: #2c2c3e;
  --md3-surface-container: #373748;
  --md3-on-surface: #ffffff;
  --md3-outline: #5c5c7c;
  --md3-shadow: rgba(0, 0, 0, 0.3);
}

body {
  background-color: var(--md3-background);
  color: var(--md3-on-surface);
  font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  margin: 0;
  padding: 0;
  transition: background-color 0.3s ease;
}

#wrapper {
  display: flex;
  min-height: 100vh;
  overflow-x: hidden;
  flex-direction: row;
}

#sidebar-wrapper {
  background: var(--md3-surface-container);
  width: 250px;
  min-height: 100vh;
  box-shadow: 4px 0 12px var(--md3-shadow);
  display: flex;
  flex-direction: column;
  justify-content: center;
  transition: all 0.3s ease;
  padding-top: 1rem;
}

.sidebar-heading {
  text-align: center;
  padding: 1rem;
  font-size: 1.25rem;
  font-weight: 600;
  color: var(--md3-primary);
  border-bottom: 1px solid var(--md3-outline);
  margin-bottom: 1rem;
}

.list-group {
  display: flex;
  flex-direction: column;
  gap: 0.5rem;
  padding: 0 1rem;
}

.list-group-item {
  background: transparent;
  border: none;
  color: rgba(255, 255, 255, 0.85);
  padding: 12px 16px;
  border-radius: 12px;
  transition: all 0.25s ease;
  display: flex;
  align-items: center;
  gap: 0.75rem;
  font-weight: 500;
  white-space: nowrap;
  cursor: pointer;
  position: relative;
  overflow: hidden;
}

.list-group-item:hover {
  background-color: rgba(255, 255, 255, 0.08);
  color: #fff;
  transform: translateX(6px);
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
}

.list-group-item i {
  min-width: 24px;
  text-align: center;
  font-size: 1rem;
  transition: transform 0.25s ease, color 0.25s ease;
}

.list-group-item:hover i {
  transform: scale(1.2) rotate(3deg);
  color: var(--md3-secondary);
}

.list-group-item:active {
  transform: scale(0.96);
  opacity: 0.9;
}

.list-group-item.active i {
  color: var(--md3-secondary);
  text-shadow: 0 0 10px var(--md3-secondary);
}

.sidebar-footer {
  text-align: center;
  color: rgba(255, 255, 255, 0.5);
  font-size: 0.8rem;
  padding: 1rem;
  border-top: 1px solid var(--md3-outline);
  margin-top: auto;
}

#page-content-wrapper {
  flex: 1;
  background-color: var(--md3-background);
  padding: 2rem;
}

.navbar {
  background-color: var(--md3-surface);
  box-shadow: 0 2px 8px var(--md3-shadow);
  padding: 0.75rem 1rem;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
}

.navbar-dark .navbar-brand,
.navbar-dark .btn {
  color: #ffffff;
}

.btn {
  background-color: var(--md3-primary);
  color: white;
  border: none;
  border-radius: 20px;
  padding: 0.5rem 1.25rem;
  transition: background-color 0.2s, transform 0.2s, box-shadow 0.2s;
  position: relative;
  overflow: hidden;
}

.btn:hover {
  background-color: #4338ca;
  box-shadow: 0 4px 12px var(--md3-shadow);
}

.btn:active {
  transform: scale(0.97);
}

.modal-content {
  background-color: var(--md3-surface);
  color: white;
  border-radius: 12px;
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.4);
}

.dropdown-item {
  color: rgba(255, 255, 255, 0.85);
  padding: 12px 20px;
  transition: background-color 0.2s ease;
}

.dropdown-item:hover {
  background-color: rgba(255, 255, 255, 0.08);
  color: white;
}

.card {
  background-color: var(--md3-surface-container);
  color: var(--md3-on-surface);
  border-radius: 12px;
  box-shadow: 0 2px 10px var(--md3-shadow);
  transition: box-shadow 0.3s ease;
}

.card:hover {
  box-shadow: 0 6px 16px rgba(0, 0, 0, 0.3);
}

.ripple {
  position: relative;
  overflow: hidden;
}

.ripple-effect {
  position: absolute;
  border-radius: 50%;
  background: rgba(255, 255, 255, 0.3);
  transform: scale(0);
  animation: ripple-md3 500ms ease-out;
  pointer-events: none;
}

@keyframes ripple-md3 {
  to {
    transform: scale(2.5);
    opacity: 0;
  }
}

@media (min-width: 768px) {
  #sidebar-wrapper {
    margin-left: 0;
  }

  #page-content-wrapper {
    min-width: 0;
    width: 100%;
  }
}
</style>
</head>
<body>
<div class="d-flex" id="wrapper">
    <div id="sidebar-wrapper">
        <div class="sidebar-heading">IBO XFAST</div>
        <div class="list-group list-group-flush">
            <a class="list-group-item list-group-item-action" href="dash.php">
                <i class="fas fa-home"></i> Dashboard
            </a>
            <a class="list-group-item list-group-item-action" href="dns.php">
                <i class="fas fa-server"></i> Servidores de DNS
            </a>

            <a class="list-group-item list-group-item-action" href="playlists.php">
                <i class="fas fa-users animate__animated animate__fadeIn"></i> Usuários conectados
            </a>
            <a class="list-group-item list-group-item-action" href="cadastrar_codigo.php">
                <i class="fas fa-code animate__animated animate__fadeIn"></i> Cadastrar Códigos
            </a>
            <a class="list-group-item list-group-item-action" href="ads.php">
                <i class="fas fa-ad"></i> Enviar de Anúncio
            </a>
            <a class="list-group-item list-group-item-action" href="ads2.php">
                <i class="fas fa-ad"></i> Enviar de Anúncio 02
            </a>
            <a class="list-group-item list-group-item-action" href="mRTXAdsSetting.php">
                <i class="fas fa-cog animate__animated animate__rotateIn"></i> Autoads/Manual
            </a>
            <a class="list-group-item list-group-item-action" href="themes.php">
                <i class="fas fa-palette animate__animated animate__rotateIn"></i> Selecionar Tema
            </a>      
            <a class="list-group-item list-group-item-action" href="settings.php">
                <i class="fas fa-comment-alt"></i> Mensagem Servers
            </a>
            <a class="list-group-item list-group-item-action" href="#" data-toggle="modal" data-target="#customizeModal">
                <i class="fas fa-paint-brush"></i> Personalizar App
                <i class="fas fa-chevron-down float-right"></i>
            </a>
            <a class="list-group-item list-group-item-action" href="chatbot.php">
                <i class="fas fa-robot"></i> Teste Automático
            </a>
<a class="list-group-item list-group-item-action" href="alterar_package.php">
    <i class="fas fa-qrcode"></i> Config Qrcode RN
</a>


            <a class="list-group-item list-group-item-action" href="pagamento.php">
                <i class="fas fa-money-bill-wave animate__animated animate__tada"></i> Pagamento
            </a>
            <a class="list-group-item list-group-item-action" href="user.php">
                <i class="fas fa-user-cog"></i> Meu Perfil
            </a>
        </div>
       <div class="sidebar-footer">
            <a href="https://t.me/brappsoficial" target="_blank" style="color: rgba(255, 255, 255, 0.6);">
                © <?=date("Y")?> IBO XFAST
        </div>
    </div>
    <div class="modal fade" id="customizeModal" tabindex="-1" role="dialog" aria-labelledby="customizeModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="customizeModalLabel">Personalizar</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <a class="dropdown-item" href="bg.php">
                        <i class="fas fa-image animate__animated animate__fadeInLeft"></i> Mudar Fundo
                    </a>
                    <a class="dropdown-item" href="logo.php">
                        <i class="fas fa-image animate__animated animate__fadeInLeft"></i> Mudar Logo
                    </a>
                    <a class="dropdown-item" href="ajustescores.php">
                        <i class="fas fa-palette animate__animated animate__fadeInLeft"></i> Cores botões
                    </a>

                    <a class="dropdown-item" href="edit_texto.php">
                        <i class="fas fa-envelope animate__animated animate__fadeInLeft"></i> Enviar Mensagem
                    </a>
                </div>
            </div>
        </div>
    </div>
 <div id="page-content-wrapper">
        <nav class="navbar navbar-expand-lg navbar-dark">
            <button class="btn btn-primary" id="menu-toggle">
                <img src="img/logo.png" width="25" height="25" class="d-inline-block align-top" alt="">
            </button>
            <div class="center" id="pageMessages"></div>
            <a href="logout.php" class="btn btn-danger ml-auto animate__animated animate__pulse">Logout</a>
        </nav>
        <div class="container-fluid"><br>
  <!-- JS: Ao final para melhor desempenho -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js" defer></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js" defer></script>
<script>
  // Efeito ripple otimizado
  document.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('.ripple').forEach(btn => {
      btn.addEventListener('click', function(e) {
        const circle = document.createElement('span');
        circle.classList.add('ripple-effect');
        const rect = this.getBoundingClientRect();
        const size = Math.max(rect.width, rect.height);
        circle.style.width = circle.style.height = size + 'px';
        circle.style.left = (e.clientX - rect.left - size / 2) + 'px';
        circle.style.top = (e.clientY - rect.top - size / 2) + 'px';

        this.appendChild(circle);
        setTimeout(() => circle.remove(), 500);
      });
    });
  });
</script>
</body>
</html>